Config = {}

-- 🌍 Language Settings ("de" = German, "en" = English)
Config.Locale = "en"

-- 🐛 Debug Mode (true = print debug logs to console)
Config.Debug = false

-- ❄️ Weather Control
-- If true, automatically sets snowy weather and tracks
Config.EnableWeatherControl = true
Config.SnowWeatherType = "XMAS" -- Weather type for snowy conditions

-- 🧊 Snowball System
Config.EnableSnowballPickup = true -- Enable snowball pickup feature
Config.SnowballKey = 38 -- Pickup key (Default: E)
Config.MaxSnowballs = 10 -- Max snowballs a player can carry

-- ⛄ Snowman Settings
Config.Snowman = {}
Config.Snowman.RequiredSnowballs = 3 -- Amount needed to build a snowman
Config.Snowman.Model = `prop_prlg_snowpile` -- Object model used for the snowman
Config.Snowman.Offset = 2.0 -- Distance in front of player to spawn the snowman
Config.Snowman.ZOffset = -0.2 -- Z-axis offset for placement
Config.Snowman.HeadingOffset = 300.0 -- Rotation relative to the player

-- 🎄 Christmas Tree Settings
Config.Tree = {}
Config.Tree.Model = `prop_xmas_ext` -- Tree prop model
Config.Tree.Coords = vector3(232.5771, -879.4227, 29.8) -- Tree spawn location (e.g., Legion Square)
Config.Tree.Heading = 0.0 -- Direction the tree faces
Config.Tree.ZOffset = -1.0 -- Z-axis offset for tree placement

-- 📝 Translations (German/English)
Config.Text = {
    ["de"] = {
        pickup_prompt = "Drücke ~INPUT_CONTEXT~ um einen Schneeball aufzuheben",
        pickup_first = "❄️ Du hast einen Schneeball aufgehoben!",
        pickup_add = "❄️ Schneeball +1",
        pickup_max = "🎅 Du hast bereits %d Schneebälle!",
        snowman_need = "❄️ Du brauchst mindestens %d Schneebälle!",
        snowman_fail = "⚠️ Fehler beim Laden des Schneemanns.",
        snowman_built = "⛄ Du hast einen Schneemann gebaut!",
        snowman_destroyed = "💥 Dein Schneemann wurde zerstört!",
        tree_spawned = "🎄 Weihnachtsbaum gespawnt am Würfelpark!",
        snowmman_not_loaded = "❌ Schneemann-Model konnte nicht geladen werden!"
    },
    ["en"] = {
        pickup_prompt = "Press ~INPUT_CONTEXT~ to pick up a snowball",
        pickup_first = "❄️ You picked up a snowball!",
        pickup_add = "❄️ Snowball +1",
        pickup_max = "🎅 You already have %d snowballs!",
        snowman_need = "❄️ You need at least %d snowballs!",
        snowman_fail = "⚠️ Failed to load the snowman.",
        snowman_built = "⛄ You built a snowman!",
        snowman_destroyed = "💥 Your snowman was destroyed!",
        tree_spawned = "🎄 Christmas tree spawned at Legion Square!",
        snowmman_not_loaded = "❌ Snowman model could not be loaded!"
    }
}

-- Debug Function (only if Config.Debug is true)
function DebugPrint(msg)
    if Config.Debug then
        print("[DEBUG] " .. tostring(msg))
    end
end

-- Translation Helper (_T("key", ...)) → auto-fills translated string based on locale
function _T(key, ...)
    local lang = Config.Locale
    local text = Config.Text[lang][key] or key
    if select("#", ...) > 0 then
        return string.format(text, ...)
    end
    return text
end