local Framework = {}

CreateThread(function()
    if GetResourceState("es_extended") == "started" then
        Framework.Type = "esx"
        Framework.Object = exports["es_extended"]:getSharedObject()
        DebugPrint("ESX detected and loaded.")
    elseif GetResourceState("qb-core") == "started" then
        Framework.Type = "qb"
        Framework.Object = exports["qb-core"]:GetCoreObject()
        DebugPrint("QBCore detected and loaded.")
    else
        print("[❌] No supported framework detected (ESX or QBCore)")
    end
end)

function ShowNotification(msg)
    if Framework.Type == "esx" then
        Framework.Object.ShowNotification(msg)
    elseif Framework.Type == "qb" then
        Framework.Object.Functions.Notify(msg, "primary")
    end
end

function ShowHelp(msg)
    if Framework.Type == "esx" then
        AddTextEntry("HELP", msg)
        DisplayHelpTextThisFrame("HELP", false)
    elseif Framework.Type == "qb" then
        AddTextEntry("HELP", msg)
        DisplayHelpTextThisFrame("HELP", false)
    end
end

if Config.EnableWeatherControl then
    CreateThread(function()
        while true do
            Wait(1000)
            SetWeatherTypePersist(Config.SnowWeatherType)
            SetWeatherTypeNowPersist(Config.SnowWeatherType)
            SetWeatherTypeNow(Config.SnowWeatherType)
            SetOverrideWeather(Config.SnowWeatherType)

            SetForcePedFootstepsTracks(true)
            SetForceVehicleTrails(true)
            SetTimecycleModifier("snow")
        end
    end)
end

if Config.EnableSnowballPickup then
    CreateThread(function()
        while true do
            Wait(0)
            local ped = PlayerPedId()
            local weaponHash = `WEAPON_SNOWBALL`
            local hasWeapon = HasPedGotWeapon(ped, weaponHash)

            if IsControlJustReleased(0, Config.SnowballKey) then
                RequestAnimDict("pickup_object")
                while not HasAnimDictLoaded("pickup_object") do Wait(0) end

                TaskPlayAnim(ped, "pickup_object", "pickup_low", 8.0, -8.0, 1000, 0, 0, false, false, false)
                Wait(1000)

                if not hasWeapon then
                    GiveWeaponToPed(ped, weaponHash, 1, false, true)
                    ShowNotification(_T("pickup_first"))
                else
                    local currentAmmo = GetAmmoInPedWeapon(ped, weaponHash)
                    if currentAmmo < Config.MaxSnowballs then
                        AddAmmoToPed(ped, weaponHash, 1)
                        ShowNotification(_T("pickup_add"))
                    else
                        ShowNotification(_T("pickup_max", Config.MaxSnowballs))
                    end
                end
            end

            ShowHelp(_T("pickup_prompt"))
        end
    end)
end

RegisterCommand("snowman", function()
    local ped = PlayerPedId()
    local coords = GetEntityCoords(ped)
    local weapon = `WEAPON_SNOWBALL`
    local snowballs = GetAmmoInPedWeapon(ped, weapon)

    if snowballs < Config.Snowman.RequiredSnowballs then
        ShowNotification(_T("snowman_need", Config.Snowman.RequiredSnowballs))
        return
    end

    RequestAnimDict("pickup_object")
    while not HasAnimDictLoaded("pickup_object") do Wait(0) end
    TaskPlayAnim(ped, "pickup_object", "pickup_low", 8.0, -8.0, 2000, 0, 0, false, false, false)
    Wait(2000)

    SetPedAmmo(ped, weapon, snowballs - Config.Snowman.RequiredSnowballs)

    RequestModel(Config.Snowman.Model)
    local timer = 0
    while not HasModelLoaded(Config.Snowman.Model) and timer < 5000 do
        Wait(10)
        timer += 10
    end

    if not HasModelLoaded(Config.Snowman.Model) then
        DebugPrint(_T("snowmman_not_loaded"))
        ShowNotification(_T("snowman_fail"))
        return
    end

    local forward = GetEntityForwardVector(ped)
    local spawnCoords = coords + forward * Config.Snowman.Offset
    local foundGround, groundZ = GetGroundZFor_3dCoord(spawnCoords.x, spawnCoords.y, spawnCoords.z + 2.0, 0)

    if foundGround then
        spawnCoords = vector3(spawnCoords.x, spawnCoords.y, groundZ)
    end

    local heading = GetHeadingFromVector_2d(coords.x - spawnCoords.x, coords.y - spawnCoords.y) + Config.Snowman.HeadingOffset

    local snowman = CreateObject(Config.Snowman.Model, spawnCoords.x, spawnCoords.y, spawnCoords.z + Config.Snowman.ZOffset, true, true, true)
    SetEntityHeading(snowman, heading)
    FreezeEntityPosition(snowman, true)

    ShowNotification(_T("snowman_built"))
    DebugPrint("✅ Snowman spawned at: " .. tostring(spawnCoords))

    CreateThread(function()
        while DoesEntityExist(snowman) do
            Wait(200)
            if HasEntityBeenDamagedByAnyPed(snowman) or HasEntityBeenDamagedByAnyVehicle(snowman) then
                ShowNotification(_T("snowman_destroyed"))
                DeleteEntity(snowman)
                break
            end
        end
    end)
end)

CreateThread(function()
    RequestModel(Config.Tree.Model)
    while not HasModelLoaded(Config.Tree.Model) do Wait(0) end

    local tree = CreateObject(
        Config.Tree.Model,
        Config.Tree.Coords.x,
        Config.Tree.Coords.y,
        Config.Tree.Coords.z + Config.Tree.ZOffset,
        false, true, false
    )
    SetEntityHeading(tree, Config.Tree.Heading)
    FreezeEntityPosition(tree, true)
    SetEntityInvincible(tree, true)
    SetEntityAsMissionEntity(tree, true, true)

    DebugPrint(_T("tree_spawned"))
end)